/*
 * Decompiled with CFR 0.152.
 */
package lightsout;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import lightsout.LightFrame;

class MenuPanel
extends JPanel
implements ActionListener {
    LightFrame thisFrame;
    JMenuBar menuBar = new JMenuBar();
    JLabel showMoves;
    String[] boardSizes = new String[]{"3x2", "4x3", "6x4", "8x5", "10x6"};

    public MenuPanel(LightFrame frame) {
        this.thisFrame = frame;
        FlowLayout menuLayout = new FlowLayout(0);
        this.setLayout(menuLayout);
        JMenu gameMenu = new JMenu("Game");
        gameMenu.setMnemonic(71);
        this.menuBar.add(gameMenu);
        JMenuItem menuItem = new JMenuItem("New game", 78);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        menuItem.addActionListener(this);
        gameMenu.add(menuItem);
        JMenu subMenu = new JMenu("Board size");
        subMenu.setMnemonic(66);
        for (int i = 0; i < this.boardSizes.length; ++i) {
            menuItem = new JMenuItem(this.boardSizes[i]);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(49 + i, 8));
            menuItem.addActionListener(this);
            subMenu.add(menuItem);
        }
        gameMenu.add(subMenu);
        subMenu = new JMenu("Game style");
        subMenu.setMnemonic(83);
        gameMenu = new JMenu("Help");
        gameMenu.setMnemonic(72);
        this.menuBar.add(gameMenu);
        menuItem = new JMenuItem("Instructions", 73);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        menuItem.addActionListener(this);
        gameMenu.add(menuItem);
        menuItem = new JMenuItem("About", 65);
        menuItem.addActionListener(this);
        gameMenu.add(menuItem);
        this.showMoves = new JLabel("Number of moves: ");
        this.menuBar.add(Box.createHorizontalGlue());
        this.menuBar.add(this.showMoves);
        this.showMoves = new JLabel("0");
        this.menuBar.add(this.showMoves);
        this.add(this.menuBar);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String selection = event.getActionCommand();
        if (selection.equals("New game")) {
            this.thisFrame.restart();
        } else if (selection.equals("Instructions")) {
            this.thisFrame.showInstructions();
        } else if (selection.equals("About")) {
            this.thisFrame.showAbout();
        } else {
            String[] dimensions = selection.split("x");
            this.thisFrame.height = Integer.parseInt(dimensions[1]);
            this.thisFrame.width = Integer.parseInt(dimensions[0]);
            this.thisFrame.restart();
        }
    }
}

