/*
 * Decompiled with CFR 0.152.
 */
package lightsout;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import lightsout.LightFrame;

public class LightGame
implements ActionListener {
    LightFrame gui;
    int height;
    int width;
    JButton clicked;
    int btnRow;
    int btnColumn;
    boolean[][] btnStates;
    int moves = 0;

    public LightGame(LightFrame in, int heightIn, int widthIn) {
        this.gui = in;
        this.height = heightIn;
        this.width = widthIn;
        this.btnStates = new boolean[this.height][this.width];
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ++this.moves;
        this.gui.thisMenu.showMoves.setText(Integer.toString(this.moves));
        this.clicked = (JButton)event.getSource();
        this.btnRow = (Integer)this.clicked.getClientProperty("row");
        this.btnColumn = (Integer)this.clicked.getClientProperty("column");
        this.changeStates(this.btnRow, this.btnColumn);
        this.checkWin();
    }

    private void changeStates(int row, int column) {
        this.changeOneState(row, column);
        if (row > 0) {
            this.changeOneState(row - 1, column);
        }
        if (row < this.height - 1) {
            this.changeOneState(row + 1, column);
        }
        if (column > 0) {
            this.changeOneState(row, column - 1);
        }
        if (column < this.width - 1) {
            this.changeOneState(row, column + 1);
        }
    }

    private void changeOneState(int row, int column) {
        boolean bl = this.btnStates[row][column] = !this.btnStates[row][column];
        if (this.btnStates[row][column]) {
            this.gui.thisBoard.buttons[row][column].setBackground(Color.RED);
        } else {
            this.gui.thisBoard.buttons[row][column].setBackground(Color.LIGHT_GRAY);
        }
    }

    private void checkWin() {
        int j;
        int i;
        for (i = 0; i < this.height; ++i) {
            for (j = 0; j < this.width; ++j) {
                if (!this.btnStates[i][j]) continue;
                return;
            }
        }
        JOptionPane.showMessageDialog(this.gui, "You solved the puzzle in " + this.moves + " moves.", "Congratulations!", -1);
        for (i = 0; i < this.height; ++i) {
            for (j = 0; j < this.width; ++j) {
                this.gui.thisBoard.buttons[i][j].setEnabled(false);
            }
        }
    }
}

