/*
 * Decompiled with CFR 0.152.
 */
package lightsout;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import lightsout.BoardPanel;
import lightsout.LightGame;
import lightsout.MenuPanel;
import lightsout.aboutText;

public class LightFrame
extends JFrame {
    public int height = 3;
    public int width = 4;
    LightGame thisGame;
    JPanel gameWindow;
    MenuPanel thisMenu;
    BoardPanel thisBoard;

    public LightFrame() {
        super("lightsOut!");
        this.setSize(500, 300);
        this.setDefaultCloseOperation(3);
        this.newBoard();
    }

    public void newBoard() {
        this.thisGame = new LightGame(this, this.height, this.width);
        this.gameWindow = new JPanel();
        this.thisMenu = new MenuPanel(this);
        this.setJMenuBar(this.thisMenu.menuBar);
        this.thisBoard = new BoardPanel(this.height, this.width, this.thisGame.btnStates);
        for (int i = 0; i < this.thisGame.height; ++i) {
            for (int j = 0; j < this.thisGame.width; ++j) {
                this.thisBoard.buttons[i][j].addActionListener(this.thisGame);
            }
        }
        BorderLayout windowLayout = new BorderLayout();
        this.gameWindow.setLayout(windowLayout);
        this.gameWindow.add((Component)this.thisMenu, "First");
        this.gameWindow.add((Component)this.thisBoard, "Center");
        this.add(this.gameWindow);
        this.setVisible(true);
    }

    public void restart() {
        this.remove(this.gameWindow);
        this.newBoard();
    }

    public void showInstructions() {
        JOptionPane.showMessageDialog(this, "lightsOut! is a simple and infuriating game.\n\nYou begin with a grid of buttons, some turned on, some turned off.\nRed represents ON.  The object is to turn them all off.  Each time\nyou click a button, the button will switch its state: if it was on,\nit will turn off, and vice versa.  In addition, all of the adjacent\nbuttons above, below, to the left and right will also switch their\ncurrent state.  Use the Game menu to choose from five different board\nsizes.  And try not to break your computer in a frustrated rage.", "Instructions", -1);
    }

    public void showAbout() {
        JOptionPane.showMessageDialog(this, new aboutText("<html><body>Colin J. Arpe made this game.<br>You should go look at his portfolio at<br>&emsp<a href=\"http://thegreenranger.us\">thegreenranger.us</a><br>then hire him.</body></html>"), "lightsAbOut!", -1);
    }
}

