/*
 * Decompiled with CFR 0.152.
 */
package bitcalc;

import bitcalc.Equation;
import java.util.Arrays;

public class FloatEquation
extends Equation {
    static final int NUMBER_SIZE = 32;
    static final int SIGN_BIT = 31;
    static final int MANT_LENGTH = 25;
    static final int EXP_START = 25;
    static final int EXP_LENGTH = 6;

    @Override
    public boolean addition() {
        byte greaterOperand;
        byte greaterExponent = this.checkGreater(25, 6, true);
        byte greaterMantissa = this.checkGreater(0, 25, false);
        byte by = greaterOperand = greaterExponent < 2 ? greaterExponent : greaterMantissa;
        if (greaterOperand == 2) {
            greaterOperand = 0;
        }
        byte lesserExponent = (byte)((greaterExponent + 1) % 2);
        while (greaterExponent < 2) {
            if (this.addOne(lesserExponent, 25, 6)) {
                return true;
            }
            this.bitShiftHalf(lesserExponent, 0, 25);
            greaterExponent = this.checkGreater(25, 6, true);
        }
        this.binaryNumber[2][31] = this.binaryNumber[greaterOperand][31];
        if (this.binaryNumber[0][31] == this.binaryNumber[1][31]) {
            for (byte i = 0; i < 2; i = (byte)(i + 1)) {
                if (this.addOne(i, 25, 6)) {
                    return true;
                }
                this.bitShiftHalf(i, 0, 25);
            }
            this.addRange(0, 25);
        } else {
            this.subtractRange(greaterOperand, 0, 25);
        }
        System.arraycopy(this.binaryNumber[0], 25, this.binaryNumber[2], 25, 6);
        this.oneToTheFront((byte)2);
        return false;
    }

    @Override
    public boolean subtraction() {
        this.binaryNumber[1][31] = !this.binaryNumber[1][31];
        return this.addition();
    }

    @Override
    public boolean multiplication() {
        this.binaryNumber[2][31] = this.binaryNumber[0][31] ^ this.binaryNumber[1][31];
        if (this.addOne((byte)0, 25, 6)) {
            return true;
        }
        this.bitShiftHalf((byte)0, 0, 25);
        System.arraycopy(this.binaryNumber[1], 0, this.binaryNumber[3], 0, 25);
        Arrays.fill(this.binaryNumber[1], 0, 25, false);
        for (int i = 24; i >= 0; --i) {
            if (this.binaryNumber[3][i]) {
                this.addRange(0, 25);
                System.arraycopy(this.binaryNumber[2], 0, this.binaryNumber[1], 0, 25);
            }
            this.bitShiftHalf((byte)0, 0, 25);
        }
        if (this.addRange(25, 6)) {
            return true;
        }
        this.oneToTheFront((byte)2);
        return false;
    }

    @Override
    public boolean division() {
        if (!this.binaryNumber[1][24]) {
            return true;
        }
        this.binaryNumber[2][31] = this.binaryNumber[0][31] ^ this.binaryNumber[1][31];
        if (this.subtractRange((byte)0, 25, 6)) {
            return true;
        }
        for (int i = 24; i >= 0; --i) {
            if (this.checkGreater(0, 25, false) != 1) {
                this.subtractRange((byte)0, 0, 25);
                System.arraycopy(this.binaryNumber[2], 0, this.binaryNumber[0], 0, 25);
                this.binaryNumber[3][i] = true;
            } else {
                this.binaryNumber[3][i] = false;
            }
            this.bitShiftHalf((byte)1, 0, 25);
        }
        System.arraycopy(this.binaryNumber[3], 0, this.binaryNumber[2], 0, 25);
        this.oneToTheFront((byte)2);
        return false;
    }

    private byte checkGreater(int start, int length, boolean isSigned) {
        int signBit;
        if (isSigned && this.binaryNumber[0][signBit = start + length - 1] != this.binaryNumber[1][signBit]) {
            return this.binaryNumber[0][signBit] ? (byte)1 : 0;
        }
        for (int i = start + length - 1; i >= start; --i) {
            if (this.binaryNumber[0][i] == this.binaryNumber[1][i]) continue;
            return this.binaryNumber[0][i] ? (byte)0 : 1;
        }
        return 2;
    }

    private void bitShiftHalf(byte whichNumber, int start, int length) {
        for (int i = start; i < start + length - 1; ++i) {
            this.binaryNumber[whichNumber][i] = this.binaryNumber[whichNumber][i + 1];
        }
        this.binaryNumber[whichNumber][start + length - 1] = false;
    }

    private boolean subtractRange(byte minuend, int start, int length) {
        boolean borrowFlag = false;
        int endBit = start + length - 1;
        byte subtrahend = (byte)((minuend + 1) % 2);
        for (int i = start; i <= endBit; ++i) {
            this.binaryNumber[2][i] = this.binaryNumber[minuend][i] ^ (this.binaryNumber[subtrahend][i] ^ borrowFlag);
            borrowFlag = this.binaryNumber[minuend][i] ? this.binaryNumber[subtrahend][i] && borrowFlag : this.binaryNumber[subtrahend][i] || borrowFlag;
        }
        if (this.binaryNumber[minuend][endBit] ^ this.binaryNumber[subtrahend][endBit]) {
            return !(this.binaryNumber[2][endBit] ^ borrowFlag);
        }
        return false;
    }

    private void oneToTheFront(byte whichNumber) {
        if (this.checkZero(whichNumber, 0, 25)) {
            return;
        }
        while (!this.binaryNumber[whichNumber][24]) {
            this.subtractOne(whichNumber, 25, 6);
            this.bitShiftDouble(whichNumber, 0, 25);
        }
    }
}

