/*
 * Decompiled with CFR 0.152.
 */
package bitcalc;

import java.util.Arrays;

public class Equation {
    boolean[][] binaryNumber = new boolean[4][32];
    static final byte OPERAND1 = 0;
    static final byte OPERAND2 = 1;
    static final byte RESULT = 2;
    static final byte TEMP = 3;

    public boolean addition() {
        return this.addRange(0, 32);
    }

    public boolean subtraction() {
        this.multByNegOne((byte)1, 0, 32);
        return this.addition();
    }

    public boolean multiplication() {
        boolean negativeResult = this.removeNegatives();
        int multiplierIndex = 0;
        System.arraycopy(this.binaryNumber[1], 0, this.binaryNumber[3], 0, 32);
        Arrays.fill(this.binaryNumber[1], false);
        do {
            if (this.binaryNumber[3][multiplierIndex]) {
                this.addition();
                System.arraycopy(this.binaryNumber[2], 0, this.binaryNumber[1], 0, 32);
            }
            ++multiplierIndex;
        } while (!this.bitShiftDouble((byte)0, 0, 32));
        for (int i = multiplierIndex; i < 32; ++i) {
            if (!this.binaryNumber[3][i]) continue;
            return true;
        }
        if (negativeResult) {
            this.multByNegOne((byte)2, 0, 32);
        }
        return false;
    }

    public boolean division() {
        if (this.checkZero((byte)1, 0, 32)) {
            return true;
        }
        boolean negativeResult = this.removeNegatives();
        this.multByNegOne((byte)1, 0, 32);
        do {
            this.addition();
            if (!this.binaryNumber[2][31]) {
                this.addOne((byte)3, 0, 32);
            }
            System.arraycopy(this.binaryNumber[2], 0, this.binaryNumber[0], 0, 32);
        } while (!this.binaryNumber[0][31]);
        System.arraycopy(this.binaryNumber[3], 0, this.binaryNumber[2], 0, 32);
        if (negativeResult) {
            this.multByNegOne((byte)2, 0, 32);
        }
        return false;
    }

    protected boolean addRange(int startBit, int rangeLength) {
        boolean carryFlag = false;
        int endBit = startBit + rangeLength - 1;
        for (int i = startBit; i <= endBit; ++i) {
            this.binaryNumber[2][i] = this.binaryNumber[0][i] ^ this.binaryNumber[1][i] ^ carryFlag;
            carryFlag = carryFlag ? this.binaryNumber[0][i] || this.binaryNumber[1][i] : this.binaryNumber[0][i] && this.binaryNumber[1][i];
        }
        if (this.binaryNumber[0][endBit] == this.binaryNumber[1][endBit]) {
            return this.binaryNumber[0][endBit] ^ this.binaryNumber[2][endBit];
        }
        return false;
    }

    protected void multByNegOne(byte whichNumber, int start, int length) {
        if (this.binaryNumber[whichNumber][length - 1]) {
            this.subtractOne(whichNumber, start, length);
            this.complement(whichNumber, start, length);
        } else {
            this.complement(whichNumber, start, length);
            this.addOne(whichNumber, start, length);
        }
    }

    protected boolean subtractOne(byte whichNumber, int start, int length) {
        int endBit = start + length - 1;
        boolean negative = this.binaryNumber[whichNumber][endBit];
        while (!this.binaryNumber[whichNumber][start] && start <= endBit) {
            this.binaryNumber[whichNumber][start] = true;
            ++start;
        }
        if (start <= endBit) {
            this.binaryNumber[whichNumber][start] = false;
        }
        return negative ? !this.binaryNumber[whichNumber][endBit] : false;
    }

    protected boolean addOne(byte whichNumber, int start, int length) {
        boolean positive;
        int endBit = start + length - 1;
        boolean bl = positive = !this.binaryNumber[whichNumber][endBit];
        while (this.binaryNumber[whichNumber][start] && start <= endBit) {
            this.binaryNumber[whichNumber][start] = false;
            ++start;
        }
        if (start <= endBit) {
            this.binaryNumber[whichNumber][start] = true;
        }
        return positive ? this.binaryNumber[whichNumber][endBit] : false;
    }

    protected void complement(byte whichNumber, int start, int length) {
        for (int i = start; i < length; ++i) {
            this.binaryNumber[whichNumber][i] = !this.binaryNumber[whichNumber][i];
        }
    }

    protected boolean removeNegatives() {
        boolean result = this.binaryNumber[0][31] ^ this.binaryNumber[1][31];
        for (byte i = 0; i < 2; i = (byte)(i + 1)) {
            if (!this.binaryNumber[i][31]) continue;
            this.multByNegOne(i, 0, 32);
        }
        return result;
    }

    protected boolean bitShiftDouble(byte whichNumber, int start, int length) {
        boolean signChange = this.binaryNumber[whichNumber][start + length - 1] ^ this.binaryNumber[whichNumber][start + length - 2];
        for (int i = start + length - 1; i > start; --i) {
            this.binaryNumber[whichNumber][i] = this.binaryNumber[whichNumber][i - 1];
        }
        this.binaryNumber[whichNumber][start] = false;
        return signChange;
    }

    protected boolean checkZero(byte whichNumber, int start, int length) {
        for (int i = start + length - 1; i >= start; --i) {
            if (!this.binaryNumber[whichNumber][i]) continue;
            return false;
        }
        return true;
    }
}

