/*
 * Decompiled with CFR 0.152.
 */
package bitcalc;

import bitcalc.CalcFrame;
import bitcalc.Equation;
import bitcalc.FloatEquation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;

public class CalcActions
implements KeyListener,
ActionListener {
    CalcFrame gui;
    Equation thisEq;
    boolean noDecimal = true;
    boolean newEntry = true;
    boolean negative = false;
    boolean outOfRange = false;
    boolean isFloat = false;
    byte operand = 0;
    String entryString = "0";
    String opString = " ";
    String[] binaryString = new String[3];
    String[] decimalString = new String[3];
    byte selectedOp;
    static final byte PLUS = 0;
    static final byte MINUS = 1;
    static final byte MULTIPLY = 2;
    static final byte DIVIDE = 3;
    static final long TWO_TO_THE_30TH = 0x40000000L;

    public CalcActions(CalcFrame in) {
        this.thisEq = new Equation();
        this.gui = in;
    }

    @Override
    public void keyTyped(KeyEvent input) {
        char key = input.getKeyChar();
        if (input.getKeyCode() == 10) {
            key = '=';
        }
        this.buttonFunctions(key);
    }

    @Override
    public void keyPressed(KeyEvent input) {
    }

    @Override
    public void keyReleased(KeyEvent input) {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String buttonLabel = event.getActionCommand();
        char[] button = buttonLabel.toCharArray();
        this.buttonFunctions(button[0]);
    }

    public void buttonFunctions(char entry) {
        if (entry >= '0' && entry <= '9') {
            if (this.newEntry) {
                this.entryString = "";
                if (this.negative) {
                    this.entryString = "-";
                }
                if (this.operand > 0) {
                    this.gui.operators.minus.setEnabled(false);
                }
                this.newEntry = false;
            }
            this.entryString = this.entryString + entry;
            this.gui.entryField.entryText.setText(this.entryString);
            this.createBinaryArray(this.entryString, this.operand);
            String string = this.binaryString[this.operand] = this.outOfRange ? "ERROR: out of range" : this.createBinaryString(this.operand);
            if (this.operand == 0) {
                this.gui.display.binaryOperand1.setText(this.binaryString[this.operand]);
            } else {
                this.gui.display.binaryOperand2.setText(this.binaryString[this.operand]);
            }
        } else if (entry == '.' && this.noDecimal && this.isFloat) {
            this.entryString = this.entryString + entry;
            this.noDecimal = false;
            this.newEntry = false;
            this.gui.entryField.entryText.setText(this.entryString);
        } else if (entry == '-') {
            if (this.newEntry && !this.negative) {
                this.negative = true;
                if (this.operand == 1) {
                    this.gui.operators.minus.setEnabled(false);
                }
                this.entryString = '-' + this.entryString;
                this.gui.entryField.entryText.setText(this.entryString);
            } else {
                if (this.operand == 1) {
                    return;
                }
                this.operatorButton(entry);
                this.selectedOp = 1;
            }
        } else if (entry == '+') {
            if (this.operand == 1) {
                return;
            }
            this.operatorButton(entry);
            this.selectedOp = 0;
        } else if (entry == '*') {
            if (this.operand == 1) {
                return;
            }
            this.operatorButton(entry);
            this.selectedOp = (byte)2;
        } else if (entry == '/') {
            if (this.operand == 1) {
                return;
            }
            this.operatorButton(entry);
            this.selectedOp = (byte)3;
        } else if (entry == '=') {
            if (this.operand < 1) {
                return;
            }
            this.createBinaryArray(this.entryString, (byte)1);
            this.binaryString[1] = this.createBinaryString((byte)1);
            this.decimalString[1] = this.convertToInteger((byte)1);
            this.gui.display.binaryOperand2.setText(this.binaryString[1]);
            this.gui.display.decimalOperand2.setText(this.decimalString[1]);
            switch (this.selectedOp) {
                case 0: {
                    this.outOfRange = this.thisEq.addition();
                    break;
                }
                case 1: {
                    this.outOfRange = this.thisEq.subtraction();
                    break;
                }
                case 2: {
                    this.outOfRange = this.thisEq.multiplication();
                    break;
                }
                case 3: {
                    this.outOfRange = this.thisEq.division();
                }
            }
            this.binaryString[2] = this.createBinaryString((byte)2);
            this.gui.display.binaryResult.setText(this.binaryString[2]);
            if (this.outOfRange) {
                this.gui.display.decimalResult.setText("ERROR: result out of range");
            } else {
                this.decimalString[2] = this.convertToInteger((byte)2);
                this.gui.display.decimalResult.setText(this.decimalString[2]);
            }
            this.operand = (byte)2;
            this.gui.operators.plus.setEnabled(true);
            this.gui.operators.minus.setEnabled(true);
            this.gui.operators.multiply.setEnabled(true);
            this.gui.operators.divide.setEnabled(true);
            this.gui.operators.equals.setEnabled(false);
        } else if (entry == 'C' || entry == 'c') {
            this.reset();
        }
    }

    public void reset() {
        this.thisEq = this.isFloat ? new FloatEquation() : new Equation();
        this.entryString = "0";
        this.noDecimal = true;
        this.newEntry = true;
        this.negative = false;
        this.outOfRange = false;
        this.operand = 0;
        this.opString = " ";
        Arrays.fill(this.binaryString, "");
        for (int i = 0; i < 4; ++i) {
            Arrays.fill(this.thisEq.binaryNumber[i], false);
        }
        this.gui.entryField.entryText.setText("0");
        this.gui.display.binaryOperand1.setText("");
        this.gui.display.decimalOperand1.setText("");
        this.gui.display.operator.setText(this.opString);
        this.gui.display.binaryOperand2.setText("");
        this.gui.display.decimalOperand2.setText("");
        this.gui.display.binaryResult.setText("");
        this.gui.display.decimalResult.setText("");
        this.gui.operators.plus.setEnabled(true);
        this.gui.operators.minus.setEnabled(true);
        this.gui.operators.multiply.setEnabled(true);
        this.gui.operators.divide.setEnabled(true);
        this.gui.operators.equals.setEnabled(false);
    }

    public void operatorButton(char operator) {
        if (this.operand == 2) {
            this.chainEquation();
        } else {
            this.createBinaryArray(this.entryString, (byte)0);
            this.binaryString[0] = this.createBinaryString((byte)0);
            this.decimalString[0] = this.convertToInteger((byte)0);
        }
        this.gui.display.binaryOperand1.setText(this.binaryString[0]);
        this.gui.display.decimalOperand1.setText(this.decimalString[0]);
        this.opString = this.opString + operator;
        this.gui.display.operator.setText(this.opString);
        this.gui.operators.plus.setEnabled(false);
        this.gui.operators.multiply.setEnabled(false);
        this.gui.operators.divide.setEnabled(false);
        this.gui.operators.equals.setEnabled(true);
        this.noDecimal = true;
        this.newEntry = true;
        this.negative = false;
        this.operand = 1;
        this.entryString = "0";
        this.gui.entryField.entryText.setText(this.entryString);
    }

    public void chainEquation() {
        int i;
        System.arraycopy(this.thisEq.binaryNumber[2], 0, this.thisEq.binaryNumber[0], 0, 32);
        this.binaryString[0] = this.binaryString[2];
        this.decimalString[0] = this.decimalString[2];
        for (i = 1; i < this.thisEq.binaryNumber.length; ++i) {
            Arrays.fill(this.thisEq.binaryNumber[i], false);
        }
        for (i = 1; i < this.binaryString.length; ++i) {
            this.binaryString[i] = "";
            this.decimalString[i] = "";
        }
        this.outOfRange = false;
        this.opString = " ";
        this.gui.display.binaryOperand2.setText("");
        this.gui.display.decimalOperand2.setText("");
        this.gui.display.binaryResult.setText("");
        this.gui.display.decimalResult.setText("");
    }

    public String convertToInteger(byte whichNumber) {
        if (this.isFloat) {
            return this.convertToFloat(whichNumber);
        }
        long integerResult = 0L;
        long powerOf2 = 0x40000000L;
        if (this.thisEq.binaryNumber[whichNumber][31]) {
            integerResult = Integer.MIN_VALUE;
        }
        for (int i = 30; i >= 0; --i) {
            if (this.thisEq.binaryNumber[whichNumber][i]) {
                integerResult += powerOf2;
            }
            powerOf2 /= 2L;
        }
        return Long.toString(integerResult);
    }

    public String convertToFloat(byte whichNumber) {
        double floatResult = 0.0;
        double powerOf2 = 1.0;
        System.arraycopy(this.thisEq.binaryNumber[whichNumber], 25, this.thisEq.binaryNumber[3], 25, 6);
        if (this.thisEq.binaryNumber[3][30]) {
            while (!this.thisEq.checkZero((byte)3, 25, 6)) {
                this.thisEq.addOne((byte)3, 25, 6);
                powerOf2 /= 2.0;
            }
        } else {
            while (!this.thisEq.checkZero((byte)3, 25, 6)) {
                this.thisEq.subtractOne((byte)3, 25, 6);
                powerOf2 *= 2.0;
            }
        }
        for (int i = 24; i >= 0; --i) {
            if (this.thisEq.binaryNumber[whichNumber][i]) {
                floatResult += powerOf2;
            }
            powerOf2 /= 2.0;
        }
        if (this.thisEq.binaryNumber[whichNumber][31]) {
            floatResult *= -1.0;
        }
        return Double.toString(floatResult);
    }

    public void createBinaryArray(String input, byte whichNumber) {
        double inputValue = Double.parseDouble(input);
        if (this.isFloat) {
            this.createFloatArray(inputValue, whichNumber);
            return;
        }
        long powerOf2 = 0x40000000L;
        this.outOfRange = Math.abs(inputValue) >= (double)(powerOf2 * 2L);
        if (this.outOfRange) {
            return;
        }
        Arrays.fill(this.thisEq.binaryNumber[whichNumber], false);
        if (inputValue < 0.0) {
            this.thisEq.binaryNumber[whichNumber][31] = true;
            inputValue += 2.147483648E9;
        }
        for (int i = 30; i >= 0; --i) {
            if (inputValue >= (double)powerOf2) {
                this.thisEq.binaryNumber[whichNumber][i] = true;
                inputValue -= (double)powerOf2;
            }
            powerOf2 /= 2L;
        }
    }

    public void createFloatArray(double value, byte whichNumber) {
        double powerOf2 = 1.0;
        Arrays.fill(this.thisEq.binaryNumber[whichNumber], false);
        if (value == 0.0) {
            return;
        }
        if (value < 0.0) {
            this.thisEq.binaryNumber[whichNumber][31] = true;
            value *= -1.0;
        }
        if (value > 1.0) {
            Arrays.fill(this.thisEq.binaryNumber[whichNumber], 25, 31, true);
            while (powerOf2 <= value && !this.outOfRange) {
                powerOf2 *= 2.0;
                this.outOfRange = this.thisEq.addOne(whichNumber, 25, 6);
            }
            powerOf2 /= 2.0;
        } else {
            while (powerOf2 > value && !this.outOfRange) {
                powerOf2 /= 2.0;
                this.outOfRange = this.thisEq.subtractOne(whichNumber, 25, 6);
            }
        }
        if (this.outOfRange) {
            return;
        }
        for (int i = 24; i >= 0; --i) {
            if (value >= powerOf2) {
                this.thisEq.binaryNumber[whichNumber][i] = true;
                value -= powerOf2;
            }
            powerOf2 /= 2.0;
            if (value == 0.0) break;
        }
    }

    public String createBinaryString(byte whichBinary) {
        String output = "";
        for (int i = 31; i >= 0; --i) {
            output = this.thisEq.binaryNumber[whichBinary][i] ? output + "1" : output + "0";
            if (i > 24) {
                if ((this.isFloat || i % 4 != 0) && (!this.isFloat || i != 31 && i != 25)) continue;
                output = output + " ";
                continue;
            }
            if (i % 4 != 0) continue;
            output = output + " ";
        }
        return output;
    }
}

